/******************************************************************************\
* FAPFrames.hpp                                                                *
*                                                                              *
* SuperUser                                                                    *
\******************************************************************************/

#ifndef _FAPFRAMES_HPP_
#define _FAPFRAMES_HPP_

#include <vector>
#include <string>

// Eyebrows FAPS definitions
#define f31 0 // inner left eyebrow
#define f32 1 // inner right eyebrow
#define f33 2 // central lef eyebrow
#define f34 3 // central right eyebrow
#define f35 4 // outer left eyebrow
#define f36 5 // outer right eyebrow

#define f31_MIN 0 // inner left eyebrow
#define f32_MIN 0 // inner right eyebrow
#define f33_MIN 0 // central lef eyebrow
#define f34_MIN 0 // central right eyebrow
#define f35_MIN 0 // outer left eyebrow
#define f36_MIN 0 // outer right eyebrow


#define f31_MAX 100 // inner left eyebrow
#define f32_MAX 100 // inner right eyebrow
#define f33_MAX 100 // central lef eyebrow
#define f34_MAX 100 // central right eyebrow
#define f35_MAX 100 // outer left eyebrow
#define f36_MAX 100 // outer right eyebrow


// Eyelids FAPS definitions
#define f19 0 // upper left eyelid 
#define f20 1 // upper right eyelid
#define f21 2 // lower left eyelid
#define f22 3 // lower right eyelid

#define f19_MIN 0 // upper left eyelid
#define f20_MIN 0 // upper right eyelid
#define f21_MIN 0 // lower left eyelid
#define f22_MIN 0 // lower right eyelid

#define f19_MAX 900 // upper left eyelid 
#define f20_MAX 1350 // upper right eyelid
#define f21_MAX 2500 // lower left eyelid
#define f22_MAX 2500 // lower right eyelid

// Eyeballs FAPS definitions
#define f23 0 // yaw left eyeball 
#define f24 1 // yaw right eyeball
#define f25 2 // pitch left eyeball
#define f26 3 // pitch right eyeball

#define f23_MIN -20 // yaw left eyeball 
#define f24_MIN -20 // yaw right eyeball
#define f25_MIN -20 // pitch left eyeball
#define f26_MIN -20 // pitch right eyeball

#define f23_MAX 20 // yaw left eyeball 
#define f24_MAX 20 // yaw right eyeball
#define f25_MAX 20 // pitch left eyeball
#define f26_MAX 20 // pitch right eyeball


// Head FAPS definitions
#define f48 0 // head pitch 
#define f49 1 // head yaw
#define f50 2 // head roll

#define f48_MIN -20000 // head pitch 
#define f49_MIN -20000 // head yaw
#define f50_MIN -5000 // head roll

#define f48_MAX 20000 // head pitch 
#define f49_MAX 20000 // head yaw
#define f50_MAX 5000 // head roll

const std::string HEADER = "2.1 Generated_By_GDL2FAP ";

const int MORPHING_RATE = 10;

const int STANDARD_STREAM_MASK[68] = { 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 0, 0, 0, 0, 0 };
const int STANDARD_STREAM[51] = { 0, 0, 10, 10, 0, 0, 10, 10, 10, 10, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 10, 0, 0, 10, 10, 10, 10, 0, 0, 0 }; 

class FAPFrames{

   public:
      FAPFrames(std::vector <int> f) { frames = f; }
      ~FAPFrames() {;}
      void put(std::vector <int> f) { frames = f; }
      std::vector <int> get() { return frames; }
   private:
      std::vector <int> frames;
};

#endif // _FAPFRAMES_HPP_
