/******************************************************************************\
* Eyeballs.hpp                                                                 *
*                                                                              *
* SuperUser                                                                    *
\******************************************************************************/

#ifndef _EYEBALLS_HPP_
#define _EYEBALLS_HPP_

#include <cstdio>
#include <vector>
#include <string>
#include <iostream>

#include "FAPFrames.hpp"
#include "Eyelids.hpp"
#include "Head.hpp"

//Eyes Motion Module! :)
#include <SaccadeGen.hpp>

//
class Eyeballs{
   public:
      //Eyeballs(int);
      Eyeballs(int, Eyelids&, Head&);
      ~Eyeballs() {;}

      void setFAPs(std::string behavior, double intensity);
      void setFAPs(double magnitude, int dir);
      std::vector <int> getFAP(int id) { return fapsAnimation[id].get(); }
      std::vector <int> getEyelidFAP(int id) { return eyelids.getFAP(id); }
      void printData();

   private:
      std::vector <FAPFrames> fapsAnimation;
      int time;

      //Testing version
      Eyelids& eyelids;
      Head& head;
};

#endif // _EYEBALLS_HPP_
