/******************************************************************************\
* GDL2FAP.hpp                                                                  *
*                                                                              *
* Rossana Baptista Queiroz                                                     *
\******************************************************************************/

#ifndef _GDL2FAP_HPP_
#define _GDL2FAP_HPP_

#include <cstdio>

#include <vector>
#include <string>

#include <iostream>
#include <fstream>
#include <sstream>

#include <Diluculum/LuaState.hpp>
#include "Structures.hpp"
#include "FAPFrames.hpp"


class GDL2FAP {
   public:
      GDL2FAP(const char *, int);
      GDL2FAP(int);

      ~GDL2FAP() {;}

      void printData();

      void loadAnimationFile();
      void saveFAPFile();
      int saveInFAPFile(std::ofstream& outputFile);

      // Para chamadas do Storyboard...
      void setLookTo(double angle, int dir) { 
         eyelids.setFAP(f19,0.0);
         eyelids.setFAP(f20,0.0);
         eyelids.setFAP(f21,0.0);
         eyelids.setFAP(f22,0.0);
         eyeballs.setFAPs(angle,dir); 
      }
      void setDefault(std::string bh, double par) { 
         eyelids.setFAP(f19,0.0);
         eyelids.setFAP(f20,0.0);
         eyelids.setFAP(f21,0.0);
         eyelids.setFAP(f22,0.0);
         eyeballs.setFAPs(bh,par); 
      }
      inline void setInitialFrameNumber(int n) { acc = n; }
   private:
      std::string filename;
      Diluculum::LuaState ls;
      Diluculum::LuaState af;
      int time;
      std::string favColor;

      int acc;

      void eyebrowsInfo();
      void eyelidsInfo();
      void eyeballsInfo();
      void headInfo();

      std::vector <FAPFrames> fapsAnimation;
      Eyebrows eyebrows;
      Eyelids eyelids;
      Eyeballs eyeballs;
      Head head;
};

#endif // _GDL2FAP_HPP_
