/******************************************************************************\
* Eyeballs.cpp                                                                 *
*                                                                              *
* SuperUser                                                                    *
\******************************************************************************/

#include "Eyeballs.hpp"

//
/*Eyeballs::Eyeballs(int t)
  {
   time = t;
   std::vector <int> frames(t);
   for(int i=0; i<4; i++)
   {
      FAPFrames ff(frames);
      fapsAnimation.push_back(ff);
   }
}*/


Eyeballs::Eyeballs(int t, Eyelids& e, Head& h)
   :eyelids(e), head(h)
{
   time = t;
   std::vector <int> frames(t);
   for(int i=0; i<4; i++)
   {
      FAPFrames ff(frames);
      fapsAnimation.push_back(ff);
   }
}


void Eyeballs::setFAPs(std::string behavior, double intensity){
   std::vector <int> framesf23;
   std::vector <int> framesf24;
   std::vector <int> framesf25;
   std::vector <int> framesf26;

   if (behavior == "static"){ //Sem movimentos do globo ocular

      for(int i=0; i<time; i++){
          framesf23.push_back(0);
          framesf24.push_back(0);
          framesf25.push_back(0);
          framesf26.push_back(0);
      }
   }

   if (behavior == "default" || behavior == "discomfort"){ // Modelo Estatistico

      SaccadeGen sacgen(1,0); // TODO: dar um jeito de trocar talking/listening
      double magnitude, direction, duration, interval;
      vector <double> velocities;
      double dirZ, dirX;

      int acc = 0;

      while (acc < time) {

         // A cada saccade, resetar dirX e dirZ
         dirX = 0;
         dirZ = 0;

         sacgen.doSaccade(0,0);

         magnitude = sacgen.getMagnitude();
         direction = sacgen.getDirection();


         duration = sacgen.getDuration() ;
         interval = sacgen.getInterval() ;
         if (behavior == "discomfort")
            interval = interval * intensity;

         velocities = sacgen.getVelocities();

         //
         //std::cout << "---- Saccade!\n";
         //std::cout << "Magnitude = " << magnitude <<  "   Duration = " << duration << "   Interval = " << interval;

         

         // Eyeballs --> Eyelids 
         if (magnitude > 0) {
            switch( (int) direction){
               case 45:
               case 90:
               case 135:
                  eyelids.setFAP(f21,acc,duration,duration+interval,magnitude*0.5/27.5);
                  eyelids.setFAP(f22,acc,duration,duration+interval,magnitude*0.5/27.5);
                  break;
               case 225:
               case 270:
               case 315:
                   eyelids.setFAP(f19,acc,duration,duration+interval,magnitude*0.7/27.5);
                   eyelids.setFAP(f20,acc,duration,duration+interval,magnitude*0.7/27.5);
                  break;
            }
         }

         // Eyeballs -> Head 
         if (behavior == "default")
         if (magnitude > 8) {
            switch( (int) direction){
               case 0:  
                  head.setFAP(f49,acc,duration,duration+interval,-magnitude*0.15/27.5);
                  break;
               case 45: 
                  head.setFAP(f50,acc,duration,duration+interval,magnitude*0.15/27.5);
                  head.setFAP(f48,acc,duration,duration+interval,magnitude*0.15/27.5);
                  break;
               case 90: 
                  head.setFAP(f48,acc,duration,duration+interval,magnitude*0.15/27.5);
                  break;
               case 135: 
                  head.setFAP(f50,acc,duration,duration+interval,-magnitude*0.15/27.5);
                  head.setFAP(f48,acc,duration,duration+interval,magnitude*0.15/27.5);
                  break;
               case 180:
                  head.setFAP(f49,acc,duration,duration+interval,magnitude*0.15/27.5);
                  break;
               case 225:
                  head.setFAP(f50,acc,duration,duration+interval,-magnitude*0.15/27.5);
                  head.setFAP(f48,acc,duration,duration+interval,-magnitude*0.15/27.5);
               case 270:
                  head.setFAP(f48,acc,duration,duration+interval,-magnitude*0.15/27.5);
                  break;
               case 315:
                  head.setFAP(f50,acc,duration,duration+interval,magnitude*0.15/27.5);
                  head.setFAP(f48,acc,duration,duration+interval,-magnitude*0.15/27.5);
                  break;
            }
         }

 
         for (int counter=0; counter< (int)duration; counter++) {

            switch(int(direction)) {
               case 0:
               case 360: dirZ += velocities[counter];
                  break;

               case 45: dirX -= velocities[counter];
                  dirZ += velocities[counter];
                  break;

               case 90: dirX -= velocities[counter];
                  break;

               case 135: dirX -= velocities[counter];
                  dirZ -= velocities[counter];
                  break;

               case 180: dirZ -= velocities[counter];
                  break;

               case 225: dirX += velocities[counter];
                  dirZ -= velocities[counter];
                  break;

               case 270: dirX += velocities[counter];
                  break;

               case 315: dirX += velocities[counter];
                  dirZ += velocities[counter];
                  break;
            }
            
            vector <int> vf21 = eyelids.getFAP(f21);
            if ( (dirX > 0) && eyelids.getIntensity() > dirX*0.5/27.5)
               dirX = dirX*0.5/27.5; 
 

             if (dirX > 18 || dirX < -18 || dirZ > 18 || dirZ < -18) {
               std::cout << "Great magnitude: " << magnitude << " direction: " << direction << "\n";
               switch((int) direction)
               {
                  case 45:
                  case 90:
                  case 135:
                  case 225:
                  case 270:
                  case 315:
                     std::cout << "Magnitute corrected!\n";
                     if (dirX > 18) dirX = 18;
                     if (dirZ > 18) dirZ = 18;
                     if (dirX < -18) dirX = -18;
                     if (dirZ < -18) dirZ = -18;
                     break;
               }
            }


            framesf23.push_back(dirX * 100000);
            framesf24.push_back(dirX * 100000);
            framesf25.push_back(dirZ * 100000);
            framesf26.push_back(dirZ * 100000);

            //std::cout << dirX << "   " << dirZ << "\n";

         }//for (int counter=0; counter< (int)duration; counter++)

         for (int counter=0; counter < int(interval); counter++){
            framesf23.push_back(dirX * 100000);
            framesf24.push_back(dirX * 100000);
            framesf25.push_back(dirZ * 100000);
            framesf26.push_back(dirZ * 100000);
         }
         acc += duration + interval;
      } // while (acc < time)
   } // if (behavior=="default")

   

   FAPFrames ff23(framesf23);
   FAPFrames ff24(framesf24);
   FAPFrames ff25(framesf25);
   FAPFrames ff26(framesf26);

   fapsAnimation[f23] = ff23;
   fapsAnimation[f24] = ff24;
   fapsAnimation[f25] = ff25;
   fapsAnimation[f26] = ff26;
}



void Eyeballs::setFAPs(double mag, int dir){
   std::vector <int> framesf23;
   std::vector <int> framesf24;
   std::vector <int> framesf25;
   std::vector <int> framesf26;

   SaccadeGen sacgen(1,0);
   double magnitude, direction, duration, interval;
   vector <double> velocities;
   double dirZ, dirX;

   int acc = 0;

   // A cada saccade, resetar dirX e dirZ
   dirX = 0;
   dirZ = 0;

   sacgen.lookTo(mag,dir);

   magnitude = sacgen.getMagnitude();
   direction = sacgen.getDirection();
   duration = sacgen.getDuration() ;
   interval = sacgen.getInterval() ;
   velocities = sacgen.getVelocities();


   // Eyeballs --> Eyelids 
   if (magnitude > 0) {
      switch( (int) direction){
         case 45:
         case 90:
         case 135:
            eyelids.setFAP(f21,acc,duration,duration+interval,magnitude*0.5/27.5);
            eyelids.setFAP(f22,acc,duration,duration+interval,magnitude*0.5/27.5);
            break;
         case 225:
         case 270:
         case 315:
            eyelids.setFAP(f19,acc,duration,duration+interval,magnitude*0.7/27.5);
            eyelids.setFAP(f20,acc,duration,duration+interval,magnitude*0.7/27.5);
            break;
      }
   }

    // Eyeballs -> Head 
 
   switch( (int) direction){
      case 0:  
         head.setFAP(f49,acc,duration,duration+interval,-magnitude*0.3/27.5);
         break;
      case 45: 
         head.setFAP(f50,acc,duration,duration+interval,magnitude*0.3/27.5);
         head.setFAP(f48,acc,duration,duration+interval,magnitude*0.3/27.5);
         break;
      case 90: 
         head.setFAP(f48,acc,duration,duration+interval,magnitude*0.3/27.5);
         break;
      case 135: 
         head.setFAP(f50,acc,duration,duration+interval,-magnitude*0.3/27.5);
         head.setFAP(f48,acc,duration,duration+interval,magnitude*0.3/27.5);
         break;
      case 180:
         head.setFAP(f49,acc,duration,duration+interval,magnitude*0.3/27.5);
         break;
      case 225:
         head.setFAP(f50,acc,duration,duration+interval,-magnitude*0.3/27.5);
         head.setFAP(f48,acc,duration,duration+interval,-magnitude*0.3/27.5);
      case 270:
         head.setFAP(f48,acc,duration,duration+interval,-magnitude*0.3/27.5);
         break;
      case 315:
         head.setFAP(f50,acc,duration,duration+interval,magnitude*0.3/27.5);
         head.setFAP(f48,acc,duration,duration+interval,-magnitude*0.3/27.5);
         break;
   }


   for (int counter=0; counter< (int)duration; counter++) {

      switch(int(direction)) {
         case 0:
         case 360: dirZ += velocities[counter];
            break;
            
         case 45: dirX -= velocities[counter];
            dirZ += velocities[counter];
            break;
            
         case 90: dirX -= velocities[counter];
            break;
            
         case 135: dirX -= velocities[counter];
            dirZ -= velocities[counter];
            break;
            
         case 180: dirZ -= velocities[counter];
            break;
            
         case 225: dirX += velocities[counter];
            dirZ -= velocities[counter];
            break;
            
         case 270: dirX += velocities[counter];
            break;
            
         case 315: dirX += velocities[counter];
            dirZ += velocities[counter];
            break;
      }
      
      framesf23.push_back(dirX * 100000);
      framesf24.push_back(dirX * 100000);
      framesf25.push_back(dirZ * 100000);
      framesf26.push_back(dirZ * 100000);
      
      std::cout << dirX << "   " << dirZ << "\n";
      
   }//for (int counter=0; counter< (int)duration; counter++)

   for (int counter=0; counter < (time-duration)+1; counter++){
            framesf23.push_back(dirX * 100000);
            framesf24.push_back(dirX * 100000);
            framesf25.push_back(dirZ * 100000);
            framesf26.push_back(dirZ * 100000);
   }


   FAPFrames ff23(framesf23);
   FAPFrames ff24(framesf24);
   FAPFrames ff25(framesf25);
   FAPFrames ff26(framesf26);

   fapsAnimation[f23] = ff23;
   fapsAnimation[f24] = ff24;
   fapsAnimation[f25] = ff25;
   fapsAnimation[f26] = ff26;
}
