/******************************************************************************\
* Eyeballs.hpp                                                                 *
*                                                                              *
* SuperUser                                                                    *
\******************************************************************************/

#ifndef _EYEBALLS_HPP_
#define _EYEBALLS_HPP_

#include <cstdio>
#include <vector>
#include <string>
#include <iostream>

#include "FAPFrames.hpp"
#include "Eyelids.hpp"
#include "Head.hpp"

//Eyes Motion Module! :)
#include <SaccadeGen.hpp>

//
class Eyeballs{
   public:
      //Eyeballs(int);
      Eyeballs(int, Eyelids&, Head&);
      ~Eyeballs() {;}

      void setFAPs(std::string behavior);
      void setFAPs(double magnitude, int dir);
      void setMode(std::string m) { if (m == "listening") mode = 1; else mode = 0; }

      std::vector <int> getFAP(int id) { return fapsAnimation[id].get(); }
      std::vector <int> getEyelidFAP(int id) { return eyelids.getFAP(id); }
      void printData();

      int calcIronicDir();
      void setMagIntensity(double it) { magnitudeIntensity = it; }
      void setIntIntensity(double it) { intervalIntensity = it; }
      void setFollowMode(bool flag) { isFollowingObject = flag; }
      void setInitialPoint(double x, double z) { globalX = x; globalZ = z; }

      double getX() { return globalX; }
      double getZ() { return globalZ; }

   private:
      std::vector <FAPFrames> fapsAnimation;
      int mode;
      int time;
      double magnitudeIntensity; // [0,..,1]
      double intervalIntensity; 

      double globalX, globalZ;
      bool isFollowingObject;

      //Testing version
      Eyelids& eyelids;
      Head& head;
};

#endif // _EYEBALLS_HPP_
