/******************************************************************************\
* Eyelids.hpp                                                                  *
*                                                                              *
* SuperUser                                                                    *
\******************************************************************************/

#ifndef _EYELIDS_HPP_
#define _EYELIDS_HPP_

#include <cstdio>
#include <vector>
#include <string>
#include <iostream>

#include "FAPFrames.hpp"

//RhoLibs library!
#include <rhondomizer.hpp>

#define BLINK_RATE_DEFAULT 85
#define BLINK_RATE_QUICK 25
#define BLINK_RATE_SLOW 105
//
class Eyelids{

   public:
      Eyelids(int);
      ~Eyelids() {;}
      
      void setBlink(std::string rate);
      void setFAP(int id, double intensity);
      void setFAP(int id, int init, int duration, int time, double intensity);

      std::vector <int> getFAP(int id) { return fapsAnimation[id].get(); }
      double getIntensity() { return intensity; }
      void printData();

   private:
      std::vector <FAPFrames> fapsAnimation;
      int time;
      int blinkRate;

      double intensity;
      int maxValue(int id);
};

#endif // _EYELIDS_HPP_
