/******************************************************************************\
* GDL2FAP.hpp                                                                  *
*                                                                              *
* Rossana Baptista Queiroz                                                     *
\******************************************************************************/

#ifndef _GDL2FAP_HPP_
#define _GDL2FAP_HPP_

#include <cstdio>

#include <vector>
#include <string>

#include <iostream>
#include <fstream>
#include <sstream>

#include <Diluculum/LuaState.hpp>
#include "Structures.hpp"
#include "FAPFrames.hpp"


class GDL2FAP {
   public:
      GDL2FAP(const char *, int);
      GDL2FAP(int);

      ~GDL2FAP() {;}

      void printData();

      void loadAnimationFile();
      void saveFAPFile();
      int saveInFAPFile(std::ofstream& outputFile);

      // Para chamadas do Storyboard...
      void setLookTo(double angle, int dir) { 
         eyelids.setFAP(f19,0.0);
         eyelids.setFAP(f20,0.0);
         eyelids.setFAP(f21,0.0);
         eyelids.setFAP(f22,0.0);
         eyeballs.setFAPs(angle,dir); 
      }
      void setDefault(std::string bh, std::string mode) { 
         eyelids.setFAP(f19,0.0);
         eyelids.setFAP(f20,0.0);
         eyelids.setFAP(f21,0.0);
         eyelids.setFAP(f22,0.0);
         eyeballs.setMode(mode);
         eyeballs.setFAPs(bh);
      }
      inline void setInitialFrameNumber(int n) { acc = n; }


      void setFollowMode(bool flag) { eyeballs.setFollowMode(flag); }
      double getX() { return eyeballs.getX(); }
      double getZ() { return eyeballs.getZ(); }
      void setInitialPoint(double x, double z) { eyeballs.setInitialPoint(x,z); }

   private:
      std::string filename;
      Diluculum::LuaState ls;
      Diluculum::LuaState af;
      int time;
      std::string favColor;

      int acc;

      void eyebrowsInfo();
      void eyelidsInfo();
      void eyeballsInfo();
      void headInfo();

      std::vector <FAPFrames> fapsAnimation;
      Eyebrows eyebrows;
      Eyelids eyelids;
      Eyeballs eyeballs;
      Head head;
};

#endif // _GDL2FAP_HPP_
