/******************************************************************************\
* Eyebrows.cpp                                                                 *
*                                                                              *
* Rossana B. Queiroz                                                           *
\******************************************************************************/

#include "Eyebrows.hpp"

Eyebrows::Eyebrows(int t)
{
   time = t;
   std::vector <int> frames(t);
   for(int i=0; i<6; i++)
   {
      FAPFrames ff(frames);
      fapsAnimation.push_back(ff);
   }
}

void Eyebrows::setFAP(int id, double intensity){
   std::vector <int> frames;

   double n = (intensity * 100)/MORPHING_RATE;
   double acc = 0.0; 
   for (int i=0; i<time; i++){
      if (acc <= (int)(intensity * 100)){
         //std::cout << intensity << "    " << (int) acc << "\n";
         frames.push_back((int)(acc));
         acc += n;
      }
      else  frames.push_back(((int)(intensity * maxValue(id))));
     
      
   }


   FAPFrames ff(frames);
   ff.put(frames);
   fapsAnimation[id] = ff; 
 
}

int Eyebrows::maxValue(int id){
   switch(id){
      case f31:
         return f31_MAX;
         break;
      case f32:
         return f32_MAX;
         break;
      case f33:
         return f33_MAX;
         break;
      case f34:
         return f34_MAX;
         break;
      case f35:
         return f35_MAX;
         break;
      case f36:
         return f36_MAX;
         break;
   }
}

int Eyebrows::minValue(int id){
   switch(id){
      case f31:
         return f31_MIN;
         break;
      case f32:
         return f32_MIN;
         break;
      case f33:
         return f33_MIN;
         break;
      case f34:
         return f34_MIN;
         break;
      case f35:
         return f35_MIN;
         break;
      case f36:
         return f36_MIN;
         break;
   }
}
