/******************************************************************************\
* GDL2FAP.cpp                                                                  *
*                                                                              *
* Rossana Baptista Queiroz                                                     *
\******************************************************************************/

#include "GDL2FAP.hpp"

GDL2FAP::GDL2FAP(const char *fn, int t)
   :eyebrows(Eyebrows(t)), eyelids(Eyelids(t)), head(Head(t)), eyeballs(Eyeballs(t,eyelids,head))
{
   filename = fn;
   ls.doFile (filename);
   time = t;

   acc = 0;
   loadAnimationFile();
}


GDL2FAP::GDL2FAP(int t)
   :eyebrows(Eyebrows(t)), eyelids(Eyelids(t)), head(Head(t)), eyeballs(Eyeballs(t,eyelids,head))
{
   time = t;
   acc = 0;
}

void GDL2FAP::loadAnimationFile()
{

   af.doFile (filename);

   std::vector <int> frames(time);
   for(int i=0; i<68; i++)
   {
      FAPFrames ff(frames);
      fapsAnimation.push_back(ff);
   }

   eyebrowsInfo();
   eyelidsInfo();
   headInfo();
   eyeballsInfo();
}

void GDL2FAP::eyebrowsInfo() {

 //Gettin' Eyebrows Info
   int n;
   std::string lr;
   std::string mov;
   double it;

   //Eyebrows eyebrows(time);

   std::cout << "---------- Eyebrows Info ----------\n";

   // inner eyebrow
   std:: cout << "Inner eyebrow:\n"; 
   n = af["Animation"]["eyebrows"]["inner"].value().asTable().size();

   if (n==2) { //left and right eyebrows are different

      for(int i=1; i<=2; i++) {

         lr  = af["Animation"]["eyebrows"]["inner"][i][1].value().asString();
         mov  = af["Animation"]["eyebrows"]["inner"][i][2].value().asString();
         it  = af["Animation"]["eyebrows"]["inner"][i][3].value().asNumber();

         //left
         if (lr == "l"){
            std::cout << "\tLeft = " << mov << "  " << it << std::endl;
            if (mov == "up")
               eyebrows.setFAP(f31,it);
            else eyebrows.setFAP(f31,-it);
         }
         //right

         if (lr == "r"){
            std::cout << "\tRight = " << mov << "  " << it << std::endl;
            if (mov == "up")
               eyebrows.setFAP(f32,it);
            else eyebrows.setFAP(f32,-it);
         }
      }

   }
   else if (n==3) {
      lr  = af["Animation"]["eyebrows"]["inner"][1].value().asString();
      mov  = af["Animation"]["eyebrows"]["inner"][2].value().asString();
      it  = af["Animation"]["eyebrows"]["inner"][3].value().asNumber();
      std::cout << "\tLeft and Right = " << mov << "  " << it << std::endl;

      if (mov == "up") {
         eyebrows.setFAP(f31,it);
         eyebrows.setFAP(f32,it);
      }
      else {
         eyebrows.setFAP(f31,-it);
         eyebrows.setFAP(f32,-it);
      }
   }


   // medial eyebrow
   std:: cout << "Medial eyebrow:\n"; 
   n = af["Animation"]["eyebrows"]["medial"].value().asTable().size();

   if (n==2) { //left and right eyebrows are different

      for(int i=1; i<=2; i++) {

         lr  = af["Animation"]["eyebrows"]["medial"][i][1].value().asString();
         mov  = af["Animation"]["eyebrows"]["medial"][i][2].value().asString();
         it  = af["Animation"]["eyebrows"]["medial"][i][3].value().asNumber();

         //left
         if (lr == "l"){
            std::cout << "\tLeft = " << mov << "  " << it << std::endl;
            if (mov == "up")
               eyebrows.setFAP(f33,it);
            else eyebrows.setFAP(f33,-it);
         }
         //right

         if (lr == "r"){
            std::cout << "\tRight = " << mov << "  " << it << std::endl;
            if (mov == "up")
               eyebrows.setFAP(f34,it);
            else eyebrows.setFAP(f34,-it);
         }
      }

   }
   else if (n==3) {
      lr  = af["Animation"]["eyebrows"]["medial"][1].value().asString();
      mov  = af["Animation"]["eyebrows"]["medial"][2].value().asString();
      it  = af["Animation"]["eyebrows"]["medial"][3].value().asNumber();
      std::cout << "\tLeft and Right = " << mov << "  " << it << std::endl;

      if (mov == "up") {
         eyebrows.setFAP(f33,it);
         eyebrows.setFAP(f34,it);
      }
      else {
         eyebrows.setFAP(f33,-it);
         eyebrows.setFAP(f34,-it);
      }

   }

   // outer eyebrow
   std:: cout << "Outer eyebrow:\n"; 
   n = af["Animation"]["eyebrows"]["outer"].value().asTable().size();
   
   if (n==2) { //left and right eyebrows are different

      for(int i=1; i<=2; i++) {

         lr  = af["Animation"]["eyebrows"]["outer"][i][1].value().asString();
         mov  = af["Animation"]["eyebrows"]["outer"][i][2].value().asString();
         it  = af["Animation"]["eyebrows"]["outer"][i][3].value().asNumber();

         //left
         if (lr == "l"){
            std::cout << "\tLeft = " << mov << "  " << it << std::endl;
             if (mov == "up") eyebrows.setFAP(f35,it);
             else eyebrows.setFAP(f35,-it);
         }
         //right

         if (lr == "r"){
            std::cout << "\tRight = " << mov << "  " << it << std::endl;
             if (mov == "up") eyebrows.setFAP(f36,it);
             else eyebrows.setFAP(f36,-it);
         }
      }

   }
   else if (n==3) {
      lr  = af["Animation"]["eyebrows"]["outer"][1].value().asString();
      mov  = af["Animation"]["eyebrows"]["outer"][2].value().asString();
      it  = af["Animation"]["eyebrows"]["outer"][3].value().asNumber();
      std::cout << "\tLeft and Right = " << mov << "  " << it << std::endl;

      if (mov == "up") {
         eyebrows.setFAP(f35,it);
         eyebrows.setFAP(f36,it);
      }
      else {
         eyebrows.setFAP(f35,-it);
         eyebrows.setFAP(f36,-it);
      }
   }
   std::cout << "\n";   
}


void GDL2FAP::eyelidsInfo() {

   //Gettin' Eyelids Info
   int n;
   std::string lr;
   std::string mov;
   double it;

   std::cout << "---------- Eyelids Info -----------\n";

   // blink behavior
   std:: cout << "Blink:\n"; 
   std::string bb = af["Animation"]["eyelids"]["blink"].value().asString();
   std::cout << "\tBehavior = " << bb << std::endl;
   eyelids.setBlink(bb);

   // upper eyelid
   std:: cout << "Upper eyelid:\n"; 
   n = af["Animation"]["eyelids"]["upper"].value().asTable().size();

   if (n==2) { //left and right eyelids are different

      for(int i=1; i<=2; i++) {

         lr  = af["Animation"]["eyelids"]["upper"][i][1].value().asString();
         mov  = af["Animation"]["eyelids"]["upper"][i][2].value().asString();
         it  = af["Animation"]["eyelids"]["upper"][i][3].value().asNumber();

         //left
         if (lr == "l"){
            std::cout << "\tLeft = " << mov << "  " << it << std::endl;
            eyelids.setFAP(f19,it);
         }
         //right

         if (lr == "r"){
            std::cout << "\tRight = " << mov << "  " << it << std::endl;
            eyelids.setFAP(f20,it);
         }
      }

   }
   else if (n==3) {
      lr  = af["Animation"]["eyelids"]["upper"][1].value().asString();
      mov  = af["Animation"]["eyelids"]["upper"][2].value().asString();
      it  = af["Animation"]["eyelids"]["upper"][3].value().asNumber();
      std::cout << "\tLeft and Right = " << mov << "  " << it << std::endl;
      eyelids.setFAP(f19,it);
      eyelids.setFAP(f20,it);
   }


   // lower eyelid
   std:: cout << "Lower eyelid:\n"; 
   n = af["Animation"]["eyelids"]["lower"].value().asTable().size();

   if (n==2) { //left and right eyelids are different

      for(int i=1; i<=2; i++) {

         lr  = af["Animation"]["eyelids"]["lower"][i][1].value().asString();
         mov  = af["Animation"]["eyelids"]["lower"][i][2].value().asString();
         it  = af["Animation"]["eyelids"]["lower"][i][3].value().asNumber();

         //left
         if (lr == "l"){
            std::cout << "\tLeft = " << mov << "  " << it << std::endl;
            eyelids.setFAP(f21,it);
         }
         //right

         if (lr == "r"){
            std::cout << "\tRight = " << mov << "  " << it << std::endl;
            eyelids.setFAP(f22,it);
         }
      }

   }
   else if (n==3) {
      lr  = af["Animation"]["eyelids"]["lower"][1].value().asString();
      mov  = af["Animation"]["eyelids"]["lower"][2].value().asString();
      it  = af["Animation"]["eyelids"]["lower"][3].value().asNumber();
      std::cout << "\tLeft and Right = " << mov << "  " << it << std::endl;
      eyelids.setFAP(f21,it);
      eyelids.setFAP(f22,it);
   }
  
   std::cout << "\n";   
}


void GDL2FAP::eyeballsInfo() {

   //Gettin' Eyeballs Info

   std::cout << "---------- Eyelballs Info ----------\n";

   // humidity
   std::string hi = af["Animation"]["eyeballs"]["humidity"].value().asString();
   std::cout << "Humidity = " << hi << std::endl;

   // pupil dilatation
   std::string pi = af["Animation"]["eyeballs"]["pupil"].value().asString();
   std::cout << "Pupil = " << pi << std::endl;

   // Movement
   // Problema: conflito Movement vs. Behavior...
   if (af["Animation"]["eyeballs"]["behavior"][1].value().asString() == "none") {
      std::cout << "Movement:" << std::endl;
      std::string gdir = af["Animation"]["eyeballs"]["movement"]["direction"].value().asString();
      std::cout << "\tDirection = " << gdir << std::endl;
      
      double angle = af["Animation"]["eyeballs"]["movement"]["magnitude"].value().asNumber();
      std::cout << "\tMagnitude = " << angle << std::endl;

      double dir;
      if (gdir == "up") dir = 90; 
      if (gdir == "down") dir = 270; 
      if (gdir == "left") dir = 180; 
      if (gdir == "right") dir = 0; 
      if (gdir == "rup") dir = 45; 
      if (gdir == "lup") dir = 135; 
      if (gdir == "ldown") dir = 225; 
      if (gdir == "rdown") dir = 315; 

      eyeballs.setFAPs(angle,dir);
   }
   std::cout << "\n";   

   // Behavior
   std::string bh = af["Animation"]["eyeballs"]["behavior"][1].value().asString();

   if (bh == "default"){
      std::string mode = af["Animation"]["eyeballs"]["behavior"][2].value().asString();
      eyeballs.setMode(mode);
      eyeballs.setFAPs(bh);
   }
   else if (bh == "discomfort"){
      double par1 = af["Animation"]["eyeballs"]["behavior"][2].value().asNumber();
      double par2 = af["Animation"]["eyeballs"]["behavior"][3].value().asNumber();

      eyeballs.setIntIntensity(par1);
      eyeballs.setMagIntensity(par2);

      eyeballs.setFAPs(bh);
   }
   else if (bh != "none") {
      double par = af["Animation"]["eyeballs"]["behavior"][2].value().asNumber();
      std::cout << "Behavior = " << bh << "  " << par << std::endl;
      eyeballs.setIntIntensity(par);
      eyeballs.setFAPs(bh);
   }
   std::cout << "\n";
}


void GDL2FAP::headInfo() {

   //Gettin' Head Info

   std::cout << "------------ Head Info -------------\n";

   // Direction
   std::string hd = af["Animation"]["head"]["direction"].value().asString();
   std::cout << "Behavior = " << hd << std::endl;

   // Pitch
   double p = af["Animation"]["head"]["pitch"].value().asNumber();
   std::cout << "Pitch = " << p << std::endl;
   head.setFAP(f48,p);

   // Yaw
   double y = af["Animation"]["head"]["yaw"].value().asNumber();
   std::cout << "Yaw = " << y << std::endl;
   head.setFAP(f49,y);

   // Roll
   double r = af["Animation"]["head"]["roll"].value().asNumber();
   std::cout << "Roll = " << r << std::endl;
   head.setFAP(f50,r);

   std::cout << "\n"; 
}



void GDL2FAP:: printData(){
   std::cout << "Favorite color = " << favColor << std::endl;
   std::cout << "Emotion = " << ls["emotion"].value().asString() << std::endl;
}

void GDL2FAP::saveFAPFile(){
   std::string outputFileName(af["Animation"]["name"].value().asString() + ".fap");
   std::ofstream outputFile( outputFileName.c_str() , std::ios::out);
   if (!outputFile) {
    std::cerr << "File cannot be opened for writtin'!\n";
    exit(1);
  }

   // FAP HEADER -- fixo 45fps
   outputFile << HEADER << "45 " << time << "\n";
   int n = saveInFAPFile(outputFile);
}


int GDL2FAP::saveInFAPFile(std::ofstream& outputFile) {

   std::vector <int> standard_masks(68);
   std::vector <int> standard_values(68);

   for(int i=0; i<68; i++){
      standard_masks[i] = STANDARD_STREAM_MASK[i];
      standard_values[i] = STANDARD_STREAM[i];
   }

   // gettin' eyelids frames
   std::vector <int> fap19 = eyelids.getFAP(f19);
   std::vector <int> fap20 = eyelids.getFAP(f20);
   std::vector <int> fap21 = eyelids.getFAP(f21);
   std::vector <int> fap22 = eyelids.getFAP(f22);


   // gettin' eyebrows frames
   std::vector <int> fap31 = eyebrows.getFAP(f31);
   std::vector <int> fap32 = eyebrows.getFAP(f32);
   std::vector <int> fap33 = eyebrows.getFAP(f33);
   std::vector <int> fap34 = eyebrows.getFAP(f34);
   std::vector <int> fap35 = eyebrows.getFAP(f35);
   std::vector <int> fap36 = eyebrows.getFAP(f36);


   // gettin' head frames
   std::vector <int> fap48 = head.getFAP(f48);
   std::vector <int> fap49 = head.getFAP(f49);
   std::vector <int> fap50 = head.getFAP(f50);


   // gettin' eyeballs frames
   std::vector <int> fap23 = eyeballs.getFAP(f23);
   std::vector <int> fap24 = eyeballs.getFAP(f24);
   std::vector <int> fap25 = eyeballs.getFAP(f25);
   std::vector <int> fap26 = eyeballs.getFAP(f26);


   for(int i=0; i<time; i++){
      for(int j=0; j<68; j++) {
         outputFile << standard_masks[j] << " ";
      }
      outputFile << "\n";
      for(int j=0; j<51; j++) {

         if (j==0) // frame number
            outputFile << acc << " ";

         else if (j == 17) {// fap 19
            outputFile << fap19[i] << " ";
         }

         else if (j == 18) {// fap 20
            outputFile << fap20[i] << " ";
         }

          else if (j == 19) {// fap 21
            outputFile << fap21[i] << " ";
         }

         else if (j == 20) {// fap 22
            outputFile << fap22[i] << " ";
         }

         else if (j == 25) {// fap 31
            outputFile << fap31[i] << " ";
         }

          else if (j == 26) {// fap 32
            outputFile << fap32[i] << " ";
         }

          else if (j == 27) {// fap 33
            outputFile << fap33[i] << " ";
         }

          else if (j == 28) {// fap 34
            outputFile << fap34[i] << " ";
         }

          else if (j == 29) {// fap 35
            outputFile << fap35[i] << " ";
         }

         else if (j == 30) {// fap 36
            outputFile << fap36[i] << " ";
         }

         else if (j == 21) {// fap 23
            outputFile << fap23[i] << " ";
            //std::cout << fap23[i] << " ";
         }

         else if (j == 22) {// fap 24
            outputFile << fap24[i] << " ";
         }

         else if (j == 23) {// fap 25
            outputFile << fap25[i] << " ";
         }

         else if (j == 24) {// fap 26
            outputFile << fap26[i] << " ";
         }

         else if (j == 37) {// fap 48
            outputFile << fap48[i] << " ";
         }

         else if (j == 38) {// fap 49
            outputFile << fap49[i] << " ";
         }

         else if (j == 39) {// fap 50
            outputFile << fap50[i] << " ";
         }

         else
            outputFile << standard_values[j] << " "; 
      }
      outputFile << "\n\n";
      acc++;
      //std::cout << "\n\n";
   }
 
}
