/******************************************************************************\
* Eyeballs.cpp                                                                 *
*                                                                              *
* SuperUser                                                                    *
\******************************************************************************/

#include "Eyeballs.hpp"

//
/*Eyeballs::Eyeballs(int t)
  {
   time = t;
   std::vector <int> frames(t);
   for(int i=0; i<4; i++)
   {
      FAPFrames ff(frames);
      fapsAnimation.push_back(ff);
   }
}*/


Eyeballs::Eyeballs(int t, Eyelids& e, Head& h)
   :eyelids(e), head(h)
{
   time = t;
   mode = 1; // default = listening

   magnitudeIntensity = 1;
   intervalIntensity = 1;

   globalX = 0;
   globalZ = 0;
   isFollowingObject = false;

   std::vector <int> frames(t);
   for(int i=0; i<4; i++)
   {
      FAPFrames ff(frames);
      fapsAnimation.push_back(ff);
   }
}


void Eyeballs::setFAPs(std::string behavior){
   std::vector <int> framesf23;
   std::vector <int> framesf24;
   std::vector <int> framesf25;
   std::vector <int> framesf26;

   if (behavior == "static"){ //Sem movimentos do globo ocular

      for(int i=0; i<time; i++){
          framesf23.push_back(0);
          framesf24.push_back(0);
          framesf25.push_back(0);
          framesf26.push_back(0);
      }
   }

   if (behavior == "default" || behavior == "discomfort" || behavior == "mutualGaze" || behavior=="ironic"){ // Modelo Estatistico

      SaccadeGen sacgen(mode,0); // TODO: dar um jeito de trocar talking/listening
      double magnitude, direction, duration, interval;
      vector <double> velocities;
      double dirZ, dirX;

      int acc = 0;

      while (acc < time) {

         // A cada saccade, resetar dirX e dirZ
         dirX = 0;
         dirZ = 0;

         sacgen.doSaccade(mode,0);

         magnitude = sacgen.getMagnitude();

         if (behavior == "ironic")
            direction = calcIronicDir();
         else direction = sacgen.getDirection();


         if (behavior == "discomfort"){
            double maxmag = magnitudeIntensity * 27.5 + 1;
            magnitude = magnitude*maxmag / 27.5;
            sacgen.lookTo(magnitude,direction);
         }

         if (behavior == "mutualGaze"){
            /* if (abs((int)magnitude) > 1.5)
               if (magnitude > 0)
                  magnitude = 1.5;
                  else magnitude = -1.5;*/
            magnitude = magnitude * 2.0 / 27.5;
            sacgen.lookTo(magnitude,direction);
         }

         if (behavior == "ironic"){
            
            switch((int) direction)
               {
                  case 45:
                  case 90:
                  case 135:
                     magnitude = magnitude + 5.0;
                     sacgen.lookTo(magnitude,direction);
                     break;
                  default:
                     magnitude = magnitude * 5.5 / 27.5;
                     sacgen.lookTo(magnitude,direction);
                     break;
               }
         }

         if (magnitude > 18) {
                //std::cout << "Great magnitude: " << magnitude << " direction: " << direction << "\n";
               switch((int) direction)
               {
                  case 45:
                  case 90:
                  case 135:
                  case 225:
                  case 270:
                  case 315:
                     //std::cout << "Magnitute corrected!\n";
                     magnitude = 18;
                     sacgen.lookTo(magnitude,direction);
                     break;
               }
            }

         duration = sacgen.getDuration() ;
         interval = sacgen.getInterval() ;

         if (behavior == "discomfort")
            interval = interval * (1 - intervalIntensity*0.9995);
         if (behavior == "ironic")
            interval = (1 - intervalIntensity) * interval;

         velocities = sacgen.getVelocities();

         //
         //std::cout << "---- Saccade!\n";
         //std::cout << "Magnitude = " << magnitude <<  "   Duration = " << duration << "   Interval = " << interval;

         

         // Eyeballs --> Eyelids 
         if (magnitude > 0) {
            switch( (int) direction){
               case 45:
               case 90:
               case 135:
                  eyelids.setFAP(f21,acc,duration,duration+interval,magnitude*0.5/27.5);
                  eyelids.setFAP(f22,acc,duration,duration+interval,magnitude*0.5/27.5);
                  break;
               case 225:
               case 270:
               case 315:
                   eyelids.setFAP(f19,acc,duration,duration+interval,magnitude*0.7/27.5);
                   eyelids.setFAP(f20,acc,duration,duration+interval,magnitude*0.7/27.5);
                  break;
            }
         }

         // Eyeballs -> Head 
         if (behavior == "default" || behavior == "ironic")
         if (magnitude > 8 || (behavior == "ironic")) {
            switch( (int) direction){
               case 0:  
                  head.setFAP(f49,acc,duration,duration+interval,-magnitude*0.15/27.5);
                  break;
               case 45: 
                  head.setFAP(f50,acc,duration,duration+interval,magnitude*0.15/27.5);
                  head.setFAP(f48,acc,duration,duration+interval,magnitude*0.15/27.5);
                  break;
               case 90: 
                  head.setFAP(f48,acc,duration,duration+interval,magnitude*0.15/27.5);
                  break;
               case 135: 
                  head.setFAP(f50,acc,duration,duration+interval,-magnitude*0.15/27.5);
                  head.setFAP(f48,acc,duration,duration+interval,magnitude*0.15/27.5);
                  break;
               case 180:
                  head.setFAP(f49,acc,duration,duration+interval,magnitude*0.15/27.5);
                  break;
               case 225:
                  head.setFAP(f50,acc,duration,duration+interval,-magnitude*0.15/27.5);
                  head.setFAP(f48,acc,duration,duration+interval,-magnitude*0.15/27.5);
               case 270:
                  head.setFAP(f48,acc,duration,duration+interval,-magnitude*0.15/27.5);
                  break;
               case 315:
                  head.setFAP(f50,acc,duration,duration+interval,magnitude*0.15/27.5);
                  head.setFAP(f48,acc,duration,duration+interval,-magnitude*0.15/27.5);
                  break;
            }
         }

 
         for (int counter=0; counter< (int)duration; counter++) {

            switch(int(direction)) {
               case 0:
               case 360: dirZ += velocities[counter];
                  break;

               case 45: dirX -= velocities[counter];
                  dirZ += velocities[counter];
                  break;

               case 90: dirX -= velocities[counter];
                  break;

               case 135: dirX -= velocities[counter];
                  dirZ -= velocities[counter];
                  break;

               case 180: dirZ -= velocities[counter];
                  break;

               case 225: dirX += velocities[counter];
                  dirZ -= velocities[counter];
                  break;

               case 270: dirX += velocities[counter];
                  break;

               case 315: dirX += velocities[counter];
                  dirZ += velocities[counter];
                  break;
            }
            
            if ( (dirX > 0) && eyelids.getIntensity() > 0.3 &&  eyelids.getIntensity() > dirX*0.5/27.5)
               dirX = dirX*0.5/27.5; 
 
            /*if (behavior == "mutualGaze"){
               if (abs((int)dirX) > 1.5)
                  if (dirX > 0)
                     dirX = 1.5;
                  else dirX = -1.5;
               if (abs((int)dirZ) > 1.5)
                   if (dirZ > 0)
                     dirZ = 1.5;
                  else dirZ = -1.5;
                  }*/

            framesf23.push_back(dirX * 100000);
            framesf24.push_back(dirX * 100000);
            framesf25.push_back(dirZ * 100000);
            framesf26.push_back(dirZ * 100000);

            //std::cout << dirX << "   " << dirZ << "\n";

         }//for (int counter=0; counter< (int)duration; counter++)

         for (int counter=0; counter < int(interval); counter++){
            framesf23.push_back(dirX * 100000);
            framesf24.push_back(dirX * 100000);
            framesf25.push_back(dirZ * 100000);
            framesf26.push_back(dirZ * 100000);
         }
         acc += duration + interval;
      } // while (acc < time)
   } // if (behavior=="default")


   FAPFrames ff23(framesf23);
   FAPFrames ff24(framesf24);
   FAPFrames ff25(framesf25);
   FAPFrames ff26(framesf26);

   fapsAnimation[f23] = ff23;
   fapsAnimation[f24] = ff24;
   fapsAnimation[f25] = ff25;
   fapsAnimation[f26] = ff26;
}



void Eyeballs::setFAPs(double mag, int dir){
   std::vector <int> framesf23;
   std::vector <int> framesf24;
   std::vector <int> framesf25;
   std::vector <int> framesf26;

   SaccadeGen sacgen(mode,0);
   double magnitude, direction, duration, interval;
   vector <double> velocities;
   double dirZ, dirX;

   int acc = 0;

   // A cada saccade, resetar dirX e dirZ
   if (isFollowingObject) {
      dirX = globalX;
      dirZ = globalZ;
   }
   else {
   dirX = 0;
   dirZ = 0;
   }
   sacgen.lookTo(mag,dir);

   magnitude = sacgen.getMagnitude();
   direction = sacgen.getDirection();
   duration = sacgen.getDuration() ;
   interval = sacgen.getInterval() ;
   velocities = sacgen.getVelocities();


   // Eyeballs --> Eyelids 
   if (magnitude > 0) {
      switch( (int) direction){
         case 45:
         case 90:
         case 135:
            eyelids.setFAP(f21,acc,duration,duration+interval,magnitude*0.5/27.5);
            eyelids.setFAP(f22,acc,duration,duration+interval,magnitude*0.5/27.5);
            break;
         case 225:
         case 270:
         case 315:
            eyelids.setFAP(f19,acc,duration,duration+interval,magnitude*0.7/27.5);
            eyelids.setFAP(f20,acc,duration,duration+interval,magnitude*0.7/27.5);
            break;
      }
   }

    // Eyeballs -> Head 
 
   switch( (int) direction){
      case 0:  
         head.setFAP(f49,acc,duration,duration+interval,-magnitude*0.3/27.5);
         break;
      case 45: 
         head.setFAP(f50,acc,duration,duration+interval,magnitude*0.3/27.5);
         head.setFAP(f48,acc,duration,duration+interval,magnitude*0.3/27.5);
         break;
      case 90: 
         head.setFAP(f48,acc,duration,duration+interval,magnitude*0.3/27.5);
         break;
      case 135: 
         head.setFAP(f50,acc,duration,duration+interval,-magnitude*0.3/27.5);
         head.setFAP(f48,acc,duration,duration+interval,magnitude*0.3/27.5);
         break;
      case 180:
         head.setFAP(f49,acc,duration,duration+interval,magnitude*0.3/27.5);
         break;
      case 225:
         head.setFAP(f50,acc,duration,duration+interval,-magnitude*0.3/27.5);
         head.setFAP(f48,acc,duration,duration+interval,-magnitude*0.3/27.5);
      case 270:
         head.setFAP(f48,acc,duration,duration+interval,-magnitude*0.3/27.5);
         break;
      case 315:
         head.setFAP(f50,acc,duration,duration+interval,magnitude*0.3/27.5);
         head.setFAP(f48,acc,duration,duration+interval,-magnitude*0.3/27.5);
         break;
   }


   for (int counter=0; counter< (int)duration; counter++) {

      switch(int(direction)) {
         case 0:
         case 360: dirZ += velocities[counter];
            break;
            
         case 45: dirX -= velocities[counter];
            dirZ += velocities[counter];
            break;
            
         case 90: dirX -= velocities[counter];
            break;
            
         case 135: dirX -= velocities[counter];
            dirZ -= velocities[counter];
            break;
            
         case 180: dirZ -= velocities[counter];
            break;
            
         case 225: dirX += velocities[counter];
            dirZ -= velocities[counter];
            break;
            
         case 270: dirX += velocities[counter];
            break;
            
         case 315: dirX += velocities[counter];
            dirZ += velocities[counter];
            break;
      }
      
      globalX = dirX;
      globalZ = dirZ;

      framesf23.push_back(dirX * 100000);
      framesf24.push_back(dirX * 100000);
      framesf25.push_back(dirZ * 100000);
      framesf26.push_back(dirZ * 100000);
      
      //std::cout << dirX << "   " << dirZ << "\n";
      
   }//for (int counter=0; counter< (int)duration; counter++)

   for (int counter=0; counter < (time-duration); counter++){
            framesf23.push_back(dirX * 100000);
            framesf24.push_back(dirX * 100000);
            framesf25.push_back(dirZ * 100000);
            framesf26.push_back(dirZ * 100000);
   }


   FAPFrames ff23(framesf23);
   FAPFrames ff24(framesf24);
   FAPFrames ff25(framesf25);
   FAPFrames ff26(framesf26);

   fapsAnimation[f23] = ff23;
   fapsAnimation[f24] = ff24;
   fapsAnimation[f25] = ff25;
   fapsAnimation[f26] = ff26;
}

int Eyeballs::calcIronicDir(){
   int dir = 0;

   double R = get_random_number_in_interval(0,100);
   if ( R >= 0.0 && R <= 33.33 ) dir = 45; //rup
   else if ( R > 33.33 && R <= 66.66 ) dir = 90; //up
   else if ( R > 66.66 && R <= 100.0 ) dir = 135; //lup
   /*else if ( R > 80.0 && R <= 84.0 ) dir = 0;
   else if ( R > 84.0 && R <= 88.00 ) dir = 180;
   else if ( R > 88.0 && R <= 92.00 ) dir = 225;
   else if ( R > 92.00 && R <= 96.00 ) dir = 270;
   else if ( R > 96.0 && R <= 100 ) dir = 315;*/

   return dir;
}
