/******************************************************************************\
* Eyelids.cpp                                                                  *
*                                                                              *
* SuperUser                                                                    *
\******************************************************************************/

#include "Eyelids.hpp"

//
Eyelids::Eyelids(int t)
{
   time = t;
   blinkRate = BLINK_RATE_DEFAULT;
   std::vector <int> frames(t);
   for(int i=0; i<4; i++)
   {
      FAPFrames ff(frames);
      fapsAnimation.push_back(ff);
   }
}

void Eyelids::setFAP(int id, double it){
   std::vector <int> frames;

   intensity = it;

   double n = (intensity * maxValue(id))/MORPHING_RATE;
   double acc = 0.0; 

   for (int i=0; i<time; i++){
      int number = (int) get_random_number_in_interval(0, 3);

      if ( (i% blinkRate==0) ) {
         switch(id){
            case f19:
               frames.push_back(800);
               break;
            case f20:
               frames.push_back(1200);
               break;
            case f21:
               frames.push_back(1500);
               break;
            case f22:
               frames.push_back(1500);
               break;
         }
      }


      else if (abs(acc) <= abs(intensity * maxValue(id))){
         //std::cout << intensity << "    " << (int) acc << "\n";
         frames.push_back((int)(acc));
         acc += n;
      }
      else  frames.push_back((int)(intensity * maxValue(id)));
     
      
   }

   FAPFrames ff(frames);
   ff.put(frames);
   fapsAnimation[id] = ff; 
 
}

int Eyelids::maxValue(int id){
   switch(id){
      case f19:
         return f19_MAX;
         break;
      case f20:
         return f20_MAX;
         break;
      case f21:
         return f21_MAX;
         break;
      case f22:
         return f22_MAX;
         break;
   }
}

void Eyelids:: setBlink(std::string rate){
   if (rate == "default") blinkRate = BLINK_RATE_DEFAULT;
   if (rate == "quick") blinkRate = BLINK_RATE_QUICK;
   if (rate == "slow") blinkRate = BLINK_RATE_SLOW;
}


void Eyelids::setFAP(int id, int init, int duration, int t, double intensity){
   std::vector <int> frames(time);
      frames = getFAP(id);

   double n = (intensity * maxValue(id))/duration;
   double acc = 0.0; 

   for (int i=init; i<init+t; i++){

      if ( (i% blinkRate==0) ) {
         switch(id){
            case f19:
               if (i < time) frames[i] =800;
               break;
            case f20:
                if (i < time) frames[i]=1200;
               break;
            case f21:
                if (i < time) frames[i]=1500;
               break;
            case f22:
                if (i < time) frames[i]=1500;
               break;
         }
      }

      else if (abs(acc) <= abs(intensity * maxValue(id)) && abs(frames[i]) < abs((intensity * maxValue(id)))){
         //std::cout << intensity << "    " << (int) acc << "\n";
         if (i<time)
            frames[i] = ((int)(acc));
         acc += n;
      }
      else {
         if (i<time && abs(frames[i]) < abs((intensity * maxValue(id))) /*&& (frames[i] * intensity * maxValue(id) > 0 )*/)
            frames[i] = (int)(intensity * maxValue(id));
         //else if (i<time) frames[i] = frames[i] + frames[i]*0.25;
      }
      
   }

   FAPFrames ff(frames);
   ff.put(frames);
   fapsAnimation[id] = ff; 
 
}

