/******************************************************************************\
* Head.cpp                                                                     *
*                                                                              *
* SuperUser                                                                    *
\******************************************************************************/

#include "Head.hpp"

//

Head::Head(int t)
{
   time = t;

   std::vector <int> frames(t);
   for(int i=0; i<3; i++)
   {
      FAPFrames ff(frames);
      fapsAnimation.push_back(ff);
   }
}

void Head::setFAP(int id, double intensity){
   std::vector <int> frames;

   double n = (intensity * maxValue(id))/MORPHING_RATE;
   double acc = 0.0; 

   for (int i=0; i<time; i++){
      
      if (acc <= (intensity * maxValue(id))){
         //std::cout << intensity << "    " << (int) acc << "\n";
         frames.push_back((int)(acc));
         acc += n;
      }
      else  frames.push_back((int)(intensity * maxValue(id)));
     
   }

   FAPFrames ff(frames);
   ff.put(frames);
   fapsAnimation[id] = ff; 
 
}

void Head::setFAP(int id, int init, int duration, int t, double intensity){
   std::vector <int> frames(time);
   frames = getFAP(id);

   double n = (intensity * maxValue(id))/duration;
   double acc = 0.0; 

   for (int i=init; i<init+t; i++){

      if (abs(acc) <= abs(intensity * maxValue(id))){
         //std::cout << intensity << "    " << (int) acc << "\n";
         if (i<time)
            frames[i] = ((int)(acc));
         acc += n;
      }
      else {
         if (i<time)
            frames[i] = (int)(intensity * maxValue(id));
      }
      
   }

   FAPFrames ff(frames);
   ff.put(frames);
   fapsAnimation[id] = ff; 
 
}



int Head::maxValue(int id){
   switch(id){
      case f48:
         return f48_MAX;
         break;
      case f49:
         return f49_MAX;
         break;
      case f50:
         return f50_MAX;
         break;
   }
}

