/******************************************************************************\
* Storyboard.cpp                                                               *
*                                                                              *
* SuperUser                                                                    *
\******************************************************************************/

#include "Storyboard.hpp"

Storyboard::Storyboard(char *fn)
{
   filename = fn;

   globalX = 0;
   globalZ = 0;

   loadFile();
   saveFAPFile();
}

void Storyboard::loadFile()
{
   int acc = 0;

   ls.doFile (filename);

   int n = ls["Storyboard"].value().asTable().size();
   int totalFrames = getTotalFrames();

   std::cout << "Number of gaze actions: " << n << std::endl;
   std::cout << "Number of frames: " << totalFrames << std::endl;

   std::string outputFileName("storyboard.fap");
   std::ofstream outputFile( outputFileName.c_str() , std::ios::out);
   if (!outputFile) {
    std::cerr << "File cannot be opened for writtin'!\n";
    exit(1);
  }

   // FAP HEADER -- fixo 45fps
   outputFile << HEADER << "45 " << totalFrames << "\n";

   for(int i=1; i<=n; i++){
      std::string action = ls["Storyboard"][i][1].value().asString();
      std::cout << "--> " << action << std::endl;

      if (action == "default") {
         std::string mode = ls["Storyboard"][i][2].value().asString();
         int time = ls["Storyboard"][i][3].value().asNumber();

         GDL2FAP gdl2fap(time);
         gdl2fap.setInitialFrameNumber(acc);
         gdl2fap.setDefault("default",mode);
         gdl2fap.saveInFAPFile(outputFile);
         acc += time;

      }
      else if (action == "lookTo" || action == "fp") {
         std::string gdir = ls["Storyboard"][i][2].value().asString();
         double angle = ls["Storyboard"][i][3].value().asNumber();
         int time = ls["Storyboard"][i][4].value().asNumber();

         int dir;
         if (gdir == "up") dir = 90;
         if (gdir == "down") dir = 270;
         if (gdir == "left") dir = 180;
         if (gdir == "right") dir = 0;
         if (gdir == "rup") dir = 45;
         if (gdir == "lup") dir = 135;
         if (gdir == "ldown") dir = 225;
         if (gdir == "rdown") dir = 315;

         GDL2FAP gdl2fap(time);
         gdl2fap.setInitialFrameNumber(acc);

         if (action == "fp"){
            gdl2fap.setInitialPoint(globalX,globalZ);
            gdl2fap.setFollowMode(true);
            gdl2fap.setLookTo(angle,dir);
            gdl2fap.setFollowMode(false);
            globalX = gdl2fap.getX();
            globalZ = gdl2fap.getZ();
         }
         else gdl2fap.setLookTo(angle,dir);

         gdl2fap.saveInFAPFile(outputFile);

         acc +=time;
      }

      else {
         std::string filename = action + ".gdl";
         int time = ls["Storyboard"][i][2].value().asNumber();

         std::cout << "Processing file " << filename << "...";
         GDL2FAP gdl2fap(filename.c_str(),time);
         gdl2fap.saveFAPFile();
         gdl2fap.setInitialFrameNumber(acc);
         gdl2fap.saveInFAPFile(outputFile);
         acc += time;
         std::cout << " OK!\n";

      }

   } 

}

void Storyboard::saveFAPFile()
{
}

int Storyboard::getTotalFrames(){
   int n = ls["Storyboard"].value().asTable().size();
   int acc = 0;
    for(int i=1; i<=n; i++){

       std::string action = ls["Storyboard"][i][1].value().asString();

       if (action == "default")
           acc += ls["Storyboard"][i][3].value().asNumber();

       else if (action == "lookTo")
           acc += ls["Storyboard"][i][4].value().asNumber();

       else acc += ls["Storyboard"][i][2].value().asNumber();
    }
    return acc;
}
